function addCell(model,reactions,j)
%
% Copyright 2008 Nick Van Damme

% global nbReactions

m = sbioselect('Type', 'compartment','Name','system');
system = m(1);

newCell = system.addcompartment(['cell' num2str(j)]);
m = sbioselect('Type', 'compartment','Name','cell1');
basicCell = m(1);
%copy all compartments
for k=1:length(basicCell.compartments)
    newComp = addcompartment(newCell, [basicCell.compartments(k).Name '_c' num2str(j)] );
    set(newComp, 'Owner', newCell );
    % copy all species
    for l=1:length(basicCell.compartments(k).Species)
        newSpec = addspecies(newComp, basicCell.compartments(k).Species(l).Name );
        set(newSpec, 'InitialAmount' , basicCell.compartments(k).Species(l).initialAmount );
        set(newSpec, 'ConstantAmount', basicCell.compartments(k).Species(l).ConstantAmount );
    end
end
%copy all species
for m=1:length(basicCell.Species)
    newSpec = addspecies(newCell, basicCell.Species(m).Name );
    set(newSpec, 'InitialAmount' , basicCell.Species(m).initialAmount );
    set(newSpec, 'ConstantAmount', basicCell.Species(m).ConstantAmount );
end

%copy all reactions (that are checked in the given reactionlist)
for n=1:size(reactions,1)
    if reactions(n) == 1
        newR = addreaction(model, 'null -> null' );
        % give reaction a name
        reaction = model.reactions(n).Reaction;
        reactionRate = model.reactions(n).ReactionRate;
        for o=1:length(system.compartments(1).compartments)
            reaction = strrep( reaction , system.compartments(1).compartments(o).Name  , ...
                [system.compartments(1).compartments(o).Name '_c' num2str(j)] );
            reactionRate = strrep( reactionRate , system.compartments(1).compartments(o).Name , ...
                [system.compartments(1).compartments(o).Name '_c' num2str(j)] );
        end
        reaction = strrep( reaction , 'cell1' , ['cell' num2str(j)] );
        reactionRate = strrep( reactionRate , 'cell1' , ['cell' num2str(j)] );
        set(newR, 'Reaction', reaction);
        set(newR, 'ReactionRate', reactionRate);
        % kinetic law
        if isempty(model.reactions(n).KineticLaw)
            model.reactions(n).addkineticlaw('Unknown');
        end
        newR.addkineticlaw('Unknown');
        for p=1:length(model.reactions(n).KineticLaw.Parameters)
            addparameter(newR.KineticLaw , model.reactions(n).KineticLaw.Parameters(p).Name , model.reactions(n).KineticLaw.Parameters(p).Value );
        end
    end
end

